/**
 * @fileOverview 换肤面板逻辑脚本，脚本中的dom操作较简单，故未引用Cube库
 * @author <a href="mailto:simonsliu@tencent.com">simonsliu</a>
 * @date 12-3-7 - 下午9:02
 */
(function() {
	/**
	 * 换肤面板单例类定义
	 */
	var ChangeThemePanel = {
		themeMap: {
			classic: '默认风格',
			green: '春风拂面',
			newyear2012: '龙腾盛世',
			'default': '简简单单',
			red: '粉红浪漫',
			yellow: '水墨印象',
			blue: '牛仔主义',
			dark: '黑金时代',
			farm: '农场皮肤'
		},
		themeItemCache: {},
		imgPathPrefix: 'images/',
		imgFileType: '.png',
		defaultTheme: 'default',
		selectedClass: 'selected', // 选中项的css类名
		/**
		 * 初始化换肤面板
		 * @param {PlainObject} options 初始化参数
		 * @param {Cube.Element} options.element 父元素
		 * @param {Function} options.onItemClick 主题项单击回调，用于发起后台逻辑
		 * @param {Function} options.onItemDblClick 主题项双击回调，用于发起后台逻辑
		 */
		initialize: function(options) {
			var themeKey, themeName, themeItem, themeMap = this.themeMap, i = 0, parent = options.element;
			for (themeKey in themeMap) {
				themeName = themeMap[ themeKey ];

				themeItem = new ThemeItem({
					index: i,
					img: this.imgPathPrefix + themeKey + this.imgFileType,
					key: themeKey,
					name: themeName,
					panel: this
				});

				parent.appendChild(themeItem.element);
				i++;
			}
			this.onItemClick = options.onItemClick;
			this.onItemDblClick = options.onItemDblClick;
		}
	};

	/**
	 * ThemeItem类
	 * @param {PlainObject} 初始化参数
	 * @param {Number} index 对象索引号
	 * @param {String} img 主题缩略图路径
	 * @param {String} name 主题名称
	 * @param {ChangeThemePanel} panel 指向ChangeThemePanle实例
	 */
	function ThemeItem(data) {
		var element, img, nameCont;

		// 构建结构
		element = this.element = document.createElement('li');
		element.className = 'theme-item';

		img = this.img = document.createElement('img');
		img.className = 'preview-img';


		nameCont = this.nameCont = document.createElement('p');
		nameCont.className = 'name-cont';

		// 设置数据
		img.src = data.img;
		nameCont.innerText = data.name;
		this.index = data.index;
		this.key = data.key;
		this.panel = data.panel;
		this.panel.themeItemCache[ this.key ] = this;

		// 绑定事件
		element.addEventListener('click', this.onItemClick.bind(this));
		element.addEventListener('dblclick', this.onItemDblClick.bind(this));

		// 加载到dom树
		element.appendChild(img);
		element.appendChild(nameCont);

		return this;
	}

	ThemeItem.prototype = {
		select: function() {
			var panel = this.panel, element = this.element;

			if (panel.selectedItem) {
				panel.selectedItem.element.classList.remove(panel.selectedClass);
			}

			panel.selectedItem = this;
			element.classList.add(panel.selectedClass);
		},
		/**
		 * 单击回调函数，这里的this对象指向所点击的ThemeItem对象
		 */
		onItemClick: function() {
			var panel = this.panel;
			this.select();
			if (panel.onItemClick && Object.prototype.toString.call(panel.onItemClick) === '[object Function]') {
				panel.onItemClick.call(panel);
			}
		},
		/**
		 * 双击回调函数，这里的this对象指向所点击的ThemeItem对象
		 */
		onItemDblClick: function() {
			var panel = this.panel;
			this.select();
			if (panel.onItemDblClick && Object.prototype.toString.call(panel.onItemDblClick) === '[object Function]') {
				panel.onItemDblClick.call(panel);
			}
		}
	};

	document.addEventListener('DOMContentLoaded', function() {
		ChangeThemePanel.initialize({
			element: document.getElementById('theme-list'),
			onItemClick: function() {
				var themeKey = this.selectedItem.key;
				qqbrowser.skin.setTheme(themeKey);
				qqbrowser.extension.builtin.config.set({skin: themeKey}, function() {});
			},
			onItemDblClick: function() {
				var themeKey = this.selectedItem.key;
				qqbrowser.skin.setTheme(themeKey);
				qqbrowser.extension.builtin.config.set({skin: themeKey}, function() {});
				qqbrowser.popup.close(qqbrowser.window.currentId(),parseInt(localStorage.getItem("popupId"), 10));
			}
		});
		qqbrowser.extension.builtin.config.get(["skinTheme"], function(retval) {
			var config = JSON.parse(retval)[0],
				themeKey = config["skinTheme"],
				themeItemCache = ChangeThemePanel.themeItemCache;
			// 异常检测，如果传过来的参数不在注册皮肤列表中，那么设置为默认皮肤
			if ( !themeKey ) {
				themeKey = ChangeThemePanel.defaultTheme;
			}

			themeItemCache[ themeKey ].select();
		});
		qqbrowser.popup.show(qqbrowser.window.currentId(), document.body.offsetWidth, document.body.offsetHeight);
	});
})();